<?php

namespace Inside\IBCA\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;
use Inside\Authentication\Models\User;

/**
 * Notifications controller.
 *
 * @category Class
 * @package  Inside\IBCA\Http\Controllers\IBCAController
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class IBCAController
{
    /**
     * Return the html view of a given newsletter
     *
     * @param Request $request
     * @param string $type
     * @param string $uuid
     * @return View
     */
    public function view(Request $request, string $type, string $uuid)
    {
        $model = call_user_func(type_to_class($type) . '::find', $uuid);

        if (!$model) {
            abort(404, 'Not found');
        }

        $config = [
            'types' => [
                'newsletters' => [
                    'notification' => [
                        'view' => 'newsletter',
                    ],
                ],
                'newsletters_hr' => [
                    'notification' => [
                        'view' => 'newsletter-hr',
                    ],
                ],
            ],
        ];

        if (!isset($config['types'][$type])) {
            abort(404, 'No view found');
        }

        /** @var User $user */
        $user = Auth::user();
        $data = [
            'to.uuid' => $user->uuid,
        ];

        /** @var View $view */
        $view = view('notifications.' . $config['types'][$type]['notification']['view'], ['model' => $model, 'data' => $data]);

        return $view;
    }
}
