<style>
    @page {
        margin: 0;
    }


    /*COVER*/
    #cover {
        page-break-after: always;
    }

    #cover img {
        width: 7cm;
    }


    /*GENERAL*/
    body {
        font-family: sans-serif;
        margin: 1cm;
        text-align: justify;
    }

    #header,
    #footer {
        position: fixed;
        left: 0;
        right: 0;
        color: #2C3E50;
        font-size: 0.9em;
    }

    #header {
        top: 1cm;
        height: 4cm;
        text-align: center;
    }

    #header img {
        width: 4cm;
    }

    #footer {
        padding-top: .3cm;
        bottom: 1.5cm;
        margin-left: 2cm;
        margin-right: 2cm;
        border-top: 0.2pt solid #979797;
    }

    .spacer {
        height: 2cm;
    }

    .spacer.little {
        height: 1cm;
    }

    .spacer.mini {
        height: 0.5cm;
    }

    .spacer + .spacer {
        display: none;
    }

    .center,
    .title--centered {
        position: absolute;
        top: 50%;
        left: 50%;
        width: max-content;
        transform: translate(-50%, -50%);
        text-align: center;
    }

    .title--centered {
        display: block;
        max-width: 10cm;
    }

    .page-title {
        position: relative;
        font-weight: bold;
    }

    hr {
        page-break-after: always;
        border: 0;
    }

    /*LIST WRAPPER*/
    p {
        font-size: 12px;
    }

    .wysiwyg {
        max-width: 100%;
        padding: 0;
        margin: 0;
        font-size: 12px!important;
    }

    .wysiwyg p {
        padding: 0;
        margin: 0 !important;
    }

    .wysiwyg p:first-child {
        margin-top: .3cm !important;
    }

    .wysiwyg h3 {
        text-align: left;
        color: #2C3E50;
        font-size: 1.2em;
    }

    .wysiwyg ul {
        padding-left: 0.5cm;
        margin: 0;
    }

    .wysiwyg ul li, .wysiwyg ol li {
        position: relative;
        padding-bottom: 0cm;
        list-style-type: none;
        line-height: 17px;
    }

    .wysiwyg ol {
        counter-reset: bclh-counter;
    }

    .wysiwyg ol li {
        counter-increment: bclh-counter;
    }

    .wysiwyg ol li::before {
        content: counter(bclh-counter) ". ";
    }

    .wysiwyg ul li::before {
        content: "";
        border-color: transparent #A9A9AA;
        border-style: solid;
        border-width: 0.35em 0 0.35em 0.45em;
        display: block;
        height: 0;
        width: 0;
        left: -1em;
        top: 0.9em;
        position: relative;
    }

    .wysiwyg ul li.answer::before {
        border: none;
    }

    .wysiwyg table {
        max-width: 100%;
        width: auto;
    }

    .wysiwyg table td {
        width: auto;
    }

    .image-wrapper {
        text-align: center;
    }

    .image-wrapper img {
        margin: 0 !important;
    }

    .wysiwyg img {
        max-width: 100%;
    }

    .wysiwyg.mixed img {
        max-width: 40%;
        display: inline-block;
    }

    .wysiwyg.mixed .body {
        max-width: 50%;
        display: inline-block;
    }

    .introduction {
        padding-top: 5px;
        background-color: #F2F2F2;
        text-align: center;
    }

    .introduction h2 {
        margin-bottom: 0;
    }

    .wysiwyg.left {
        padding-right: 10px;
    }

    .wysiwyg.right {
        padding-left: 10px;
    }

    table.section, table.section tr, table.section td {
        vertical-align: top;
        text-align: justify;
    }

    /*TEXTS*/
    h2,
    h3 {
        color: #194888;
    }

    h2 {
        font-size: 2em!important;
        padding: 0;
        margin-top: 0.7cm;
        margin-bottom: 0;
    }

    h2.title {
        color: #2C3E50;
        text-align: center;
        font-size: 1.7em;
        margin-top: 0;
        margin-bottom: 0;
        padding: 0;
    }

    .file-container {
        border-left: 3px solid #194888;
        padding: 20px 30px;
        margin-top: 20px;
        margin-bottom: 20px;
    }

    .file-container a {
        color: #194888;
        text-decoration: none;
    }

    .file-container .filesize {
        color: #727272;
        font-size: 0.9em;
    }
</style>
