@foreach($contents as $content)
  @if (in_array($content['type'], ['text', 'image']))
    <div class="wysiwyg">
      {!! $content['body'] !!}
    </div>
  @elseif($content['type'] === 'accordion')
      <div class="wysiwyg">
          <ul>
              <li class="question">
                  {{ $content['question'] }}
              </li>
              <li class="answer">
                  <div class="wysiwyg">
                      {!! $content['answer'] !!}
                  </div></li>
          </ul>
      </div>
  @elseif($content['type'] === 'text_with_image')
    @if ($content['display'] === 'center')
      <div class="wysiwyg">
        {!! $content['image'] !!}
      </div>
      <div class="wysiwyg">
        {!! $content['body'] !!}
      </div>
    @elseif ($content['display'] === 'left')
      <table class="section">
        <tr>
          <td width="40%">
            <div class="wysiwyg">
              {!! $content['image'] !!}
            </div>
          </td>
          <td>
            <div class="wysiwyg right">
              {!! $content['body'] !!}
            </div>
          </td>
        </tr>
      </table>
    @else
      <table class="section">
        <tr>
          <td>
            <div class="wysiwyg left">
              {!! $content['body'] !!}
            </div>
          </td>
          <td width="40%">
            <div class="wysiwyg">
              {!! $content['image'] !!}
            </div>
          </td>
        </tr>
      </table>
    @endif
  @elseif($content['type'] === 'file')
      <div class="file-container">
          <table>
              <tr>
                  <td rowspan="2"><img src="data:image/png;base64,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" alt="" style="height: 45px;"></td>
                  <td><a href="/{{ $content['path'] }}">{{ $content['filename'] }}</a></td>
              </tr>
              <tr>
                  <td class="filesize">{{ $content['size'] }}</td>
              </tr>
          </table>
      </div>
  @endif
@endforeach
