<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Host\Bridge\BridgeContentType;

class CreateFlashNewsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->changeFieldTitle(
            'news',
            'is_featured',
            [
                'fr' => 'Remonte dans Stratégie d\'entreprise'
            ]
        );

        $this->bootUp(__FILE__);
        $this->migrateContent('flash_news');
        $this->finishUp();
    }
}
