<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldFileForSequence extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'sequences',
            'file',
            [
                'name' => 'file',
                'searchable' => true,
                'default' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Fichier',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::FILE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                    ],
                    'weight' => 5,
                ],
                'type' => BridgeContentType::FILE_FIELD,
                'settings' => [
                    'display_field' => false,
                    'display_default' => false,
                    'uri_scheme' => 'public',
                    'target_type' => 'file',
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
