<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

class ChangeProjectPageSlug extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $projectPage = Custom::query()->where('title', 'Les projets')->first();

        if (!$projectPage) {
            return;
        }

        $bridge->contentUpdate('custom', [
            'uuid' => $projectPage->uuid,
            'title' => "Stratégie"
        ]);

        $bridge->contentInsert('news_categories', [
            'type' => 'node',
            'bundle' => 'news_categories',
            'title' => 'Stratégie'
        ]);
    }

    public function down(): void
    {
    }
}
