<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\ShortcutsMenus;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Symfony\Component\Console\Helper\ProgressBar;
use Symfony\Component\Console\Output\ConsoleOutput;

class ConvertShortcutsToTools extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        $bridgeType->contentTypeCreateOrUpdateField(
            'users',
            'tools',
            [
                'name' => 'tools',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'editable' => true,
                'title' => [
                    'fr' => 'Mes accès rapides',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'target_type' => 'tools',
                    'cardinality' => -1,
                ],
            ],
            null,
            'user'
        );

        $tools = [];
        $shortcutsMenus = ShortcutsMenus::query()->get();
        $bridge = new BridgeContent();

        foreach ($shortcutsMenus as $shortcutsMenu) {
            $tool = Tools::query()->where('link', $shortcutsMenu->link)->where('langcode', $shortcutsMenu->langcode)->first();

            if (empty($tool)) {
                $data = [
                    'bundle' => 'tools',
                    'link' => $shortcutsMenu->link,
                    'title' => $shortcutsMenu->title,
                    'image' => $shortcutsMenu->image,
                    'author' => $shortcutsMenu->author,
                    'type' => 'node',
                ];
                $bridge->contentInsert('tools', $data);
            }
        }

        $users = Users::query()->get();

        $output = new ConsoleOutput();
        $bar = new ProgressBar($output, $users->count());
        $bar->setFormat("%message%\n %current%/%max% [%bar%] %percent:3s%%");
        $bar->setMessage("Converting shortcuts for " . $users->count() . " users");
        $bar->start();

        if (!isset($shortcutsMenu)) {
            return;
        }

        /** @var Users $user */
        foreach ($users as $user) {
            $tool = Tools::query()->where('link', $shortcutsMenu->link)->where('langcode', $shortcutsMenu->langcode)->first();
            $bar->setMessage("Converting shortcuts for user " . $user->name);

            if (empty($user->shortcutsMenus)) {
                $bar->advance();
                continue;
            }

            $tools[$shortcutsMenu->uuid] = $tool->uuid;
            $userTools = [];

            foreach ($user->shortcutsMenus as $shortcutsMenu) {
                if (array_key_exists($shortcutsMenu->uuid, $tools)) {
                    $userTools[] = $tools[$shortcutsMenu->uuid];
                }
            }

            $bridge->contentUpdate('users', [
                'uuid_host' => $user->uuid_host,
                'tools' => $userTools,
            ]);

            $bar->advance();
        }
    }

    public function down(): void
    {
    }
}
