<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddImageFieldToDirectVideos extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'direct_videos',
            'image',
            [
                'name' => 'image',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Image de prévisualisation',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
            3
        );
    }

    public function down(): void
    {
    }
}
