<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddDailyNews extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('daily_news');

        $this->finishUp();
    }

    public function down(): void
    {
        $this->bridge = new BridgeContentType();

        $this->bridge->contentTypeDelete('daily_news');
    }
}
