<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AlphaAddContent extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContent();

        $contentMap = [
            'projects' => [
                'Hrambee',
                'MBCA',
                'Spécialités',
                'Efficience opértionnelle',
                'Recrutement et intégration',
                'Travail à distance',
            ],
            'projects_events_categories' => [
                'Cadrage',
                'Préparation',
                'Déploiement',
                'Stabilisation',
            ],
        ];

        foreach ($contentMap as $contentType => $contents) {
            foreach ($contents as $content) {
                $bridge->contentInsert(
                    $contentType,
                    [
                        'type' => 'node',
                        'bundle' => $contentType,
                        'title' => $content,
                    ]
                );
            }
        }
    }

    public function down(): void
    {
    }
}
