<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AlphaMigration extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('projects');
        $this->migrateContent('projects_news');
        $this->migrateContent('projects_events_categories');
        $this->migrateContent('projects_events');

        $this->finishUp();
    }

    public function down(): void
    {
        $this->bridge = new BridgeContentType();

        $this->bridge->contentTypeDelete('projects');
        $this->bridge->contentTypeDelete('projects_news');
        $this->bridge->contentTypeDelete('projects_events_categories');
        $this->bridge->contentTypeDelete('projects_events');
    }
}
