<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'name' => 'xps_projects_folders',
        'title' => [
            'fr' => 'Dossiers projets XPS',
        ],
    ],
    'fields' => [
        [
            'name' => 'xps_projects_phases',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => true,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Phase projet XPS'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['xps_projects_phases'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'xps_projects_folders',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Dossier parent'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['ia_projects_folders'],
                'cardinality' => 1,
            ],
        ],
    ]
];
