<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'olympics_teams',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Équipe olympiades',
        ],
    ],
    'fields' => [
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Introduction',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'users',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Utilisateurs',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Classement',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
