<?php

namespace Inside\IBCA\Providers;

use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\IBCA\Console\ExportHrGed;
use Inside\IBCA\Http\Middleware\IBCAMiddleware;
use Inside\IBCA\Listeners\NewsletterCreatedListener;
use Inside\IBCA\Listeners\NewsletterUpdatedListener;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Inside\IBCA\Console\ImportCommand;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentCreatedEvent::class => [
            NewsletterCreatedListener::class,
        ],
        ContentUpdatedEvent::class => [
            NewsletterUpdatedListener::class,
        ],
    ];

    protected array $commands = [
        ExportHrGed::class,
        ImportCommand::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/app.php', 'app');
            $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware([
            IBCAMiddleware::class,
        ]);

        // Registering useful stuffs
        $this->app->register(\Orchestra\Parser\XmlServiceProvider::class);
        $this->app->register(\Stevebauman\Purify\PurifyServiceProvider::class);

        // Aliases
        $this->app->alias('XmlParser', \Orchestra\Parser\Xml\Facade::class);
        $this->app->alias('Purify', \Stevebauman\Purify\Facades\Purify::class);
    }
}
