<?php

namespace Inside\IBCA\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Inside\Host\Bridge\BridgeAuthentication;

/**
 * Inside Authentication middleware.
 *
 * @category Class
 * @package  Inside\Authentication\Http\Middleware\AuthenticationMiddleware
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class IBCAMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        $bridge = new BridgeAuthentication();

        define('BASE_URI_PATH', '/legacy-doc');

        if (str_starts_with($_SERVER['REQUEST_URI'], BASE_URI_PATH) && $bridge->isAuthenticated()) {
            define('BASE_DOC_PATH', env('IBCA_BASE_LEGACY_DOC_PATH', '/app/export_ged/!SSL!/WebHelp'));

            $current_uri = str_replace(BASE_URI_PATH, '', $_SERVER['REQUEST_URI']);

            if (in_array($current_uri, ['', '/'])) {
                header('Location: '.BASE_URI_PATH.'/documentation_expertise.htm');
                exit;
            }

            $current_file = BASE_DOC_PATH.$current_uri;

            if (file_exists($current_file)) {
                /** @var string $current_file_mime */
                $current_file_mime = mime_content_type($current_file);

                /** @var array $current_file_data */
                $current_file_data = pathinfo($current_file);

                switch ($current_file_data['extension']) {
                    case 'js':
                        header('Content-Type: application/javascript');
                        break;
                    case 'css':
                        header('Content-Type: text/css');
                        break;
                    case 'htm':
                        // htm files aren't considered natively as text/html :/
                        header('Content-Type: text/html');
                        break;
                    default:
                        // For all others downloadable files of the GED
                        if (str_contains($current_file_mime, 'application/')) {
                            header('Content-Description: File Transfer');
                            header('Content-Type: '.$current_file_mime);
                            header('Content-Disposition: attachment; filename='.basename($current_file));
                            header('Content-Transfer-Encoding: binary');
                            header('Expires: 0');
                            header('Cache-Control: must-revalidate');
                            header('Pragma: public');
                            header('Content-Length: '.filesize($current_file));
                        }
                        break;
                }
                ob_clean();
                flush();
                readfile($current_file);
                exit;
            } else {
                http_response_code(404);
                die('404 / Ressource not found.');
            }
        }

        return $next($request);
    }
}
