<?php

namespace Inside\IBCA\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\DailyNews;
use Inside\Content\Models\Contents\DirectPopin;
use Laravel\Lumen\Routing\Controller;
use Inside\Reaction\Facades\Reactions;

class PopinController extends Controller
{
    public function popin(Request $request): array
    {
        $dailyNews = DailyNews::query()->where('status', 1)->orderBy('created_at', 'DESC')->first();

        if (empty($dailyNews)) {
            return [
                'popin' => false,
            ];
        }

        /** @var User $user */
        $user = Auth::user();
        $reaction = DB::table('inside_reactions')
            ->where('type', 'dailynews')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $dailyNews->uuid)
            ->where('created_at', 'LIKE', date('Y-m-d', time()) . ' %')
            ->orderBy('created_at', 'DESC')->get();

        $count = $reaction->count();

        return [
            'popin' => !(bool)$count,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first()
        ];
    }

    public function directPopin(Request $request): array
    {
        $popin = DirectPopin::query()->where('status', 1)->where('activated', 1)->orderBy('created_at', 'DESC')->first();

        if (empty($popin)) {
            return [
                'popin' => false
            ];
        }

        /** @var User $user */
        $user = Auth::user();
        $reaction = DB::table('inside_reactions')
            ->where('type', 'directpopin')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $popin->uuid)
            ->where('created_at', 'LIKE', date('Y-m-d', time()) . ' %')
            ->orderBy('created_at', 'DESC')->get();

        $count = $reaction->count();

        return [
            'popin' => !(bool)$count,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first()
        ];
    }

    private function registerReaction(string $type, string $uuid): array
    {
        /** @var User $user */
        $user = Auth::user();

        $reactions = DB::table('inside_reactions')
            ->where('type', Str::lower($type))
            ->where('user_uuid', $user->uuid)
            ->orderBy('created_at', 'DESC')->get();

        $class = type_to_class($type);

        $data = call_user_func($class . '::find', $uuid);

        if ($reactions->count()) {
            foreach ($reactions as $reaction) {
                Reactions::delete($type, $reaction->reactionable_uuid, $reaction->user_uuid, $reaction->langcode);
            }
        }

        $create = Reactions::create([
            'user_uuid' => $user->uuid,
            'reactionable_uuid' => $uuid,
            'reactionable_type' => $class,
            'type' => Str::lower($type),
            'langcode' => $data->langcode
        ]);

        return $create;
    }

    public function reaction(Request $request): array
    {
        return $this->registerReaction('dailyNews', $request->get('uuid'));
    }

    public function reactToPopin(Request $request): array
    {
        return $this->registerReaction('directPopin', $request->get('uuid'));
    }
}
