<?php

namespace Inside\IBCA\Console;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Inside\Host\Bridge\BridgeContent;
use Inside\IBCA\WebHelp\Importer;

/**
 * IBCA import command.
 *
 * @category Class
 * @package  Inside\IBCA\Console\ImportCommand
 * @author   Maecia <contact@feldoe.net>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ImportCommand extends Command
{
    /**
     * @var string
     */
    protected $name = 'ged:import';

    /**
     * @var string
     */
    protected $description = 'BCA import GED';

    protected $signature = 'ged:import
                            {--documents=false}
                            {--hr-documents=false}
                            {--robohelp-documents=false}';

    /**
     * @throws \Exception
     */
    public function handle(): void
    {
        $now = Carbon::now();

        $this->info('Starting to import at ['.$now->toFormattedDateString().' '.$now->toTimeString().'], long process, wait ...');
        $documents = (bool)$this->option('documents');
        $robohelpDocuments = (bool)$this->option('robohelp-documents');
        $hrDocuments = (bool)$this->option('hr-documents');
        $importer = new Importer(new BridgeContent());
        $imported = $importer->import($this, $documents, $hrDocuments, $robohelpDocuments);
        $this->info('Importation is finished ['.$imported.'] done, started ['.$now->diffForHumans().']');
    }
}
