<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class CreateSomeCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $pages =  [
            [
                'title' => 'Evénements',
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage'
            ],
            [
                'title' => 'Solution IA',
                'custom_slug' => 'ia',
                'redirection_page' => 'ProjectIaListingPage'
            ],
            [
                'title' => 'Groupes collaboratifs',
                'custom_slug' => 'groups',
                'redirection_page' => 'TeamsListingPage'
            ],
            [
                'title' => 'Les projets',
                'custom_slug' => 'project-list',
                'redirection_page' => 'ProjectListPage'
            ],
            [
                'title' => 'Alpha',
                'custom_slug' => 'alpha',
                'redirection_page' => 'ProjectAlphaListingPage'
            ],
            [
                'title' => 'Bca Assistance',
                'custom_slug' => 'assistance',
                'redirection_page' => 'BcaAssistancePage'
            ]

        ];
        foreach ($pages as $page) {
            $bridge->contentInsert('custom', [
                'langcode' => 'fr',
                'title' => $page['title'],
                'custom_slug' => $page['custom_slug'],
                'redirection_page' => $page['redirection_page']
            ]);
        }
    }
}
