<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Host\Bridge\BridgeContentType;

class CreateFinalContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'olympics', 'image');

        $this->bootUp(__FILE__);

        $this->migrateContent('gallery_item', false, 'sections');
        $this->migrateContent('gallery', false, 'sections');
        $this->migrateContent('olympics_teams');
        $this->migrateContent('olympics_final');
        $this->migrateContent('olympics_semifinal');
        $this->migrateContent('olympics');
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
