<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class RefactoRhSpace extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'sequences', 'content');

        $this->bootUp(__FILE__);
        $this->migrateContent('rh_pages');
        $this->migrateContent('job_exchanges');
        $this->migrateContent('rh_folders');
        $this->migrateContent('rh_documents');
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
