<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditPerimeterFieldInPhases extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'xps_projects_phases',
            'perimeters',
            [
                'name' => 'perimeters',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Périmètre',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            4
        );
    }

    public function down(): void
    {
    }
}
