<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditIaProjectsCategoryField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'ia_projects',
            'categories',
            [
                'name' => 'categories',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 9,
                'title' => [
                    'fr' => 'Catégorie',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            9
        );
    }

    public function down(): void
    {
    }
}
