<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldPhaseInGroups extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'groups',
            'xps_projects_phases',
            [
                'name' => 'xps_projects_phases',
                'searchable' => true,
                'translatable' => false,
                'default' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Phase de projet',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 8,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['xps_projects_phases'],
                    'cardinality' => -1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
