<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AlphaAddStatus extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('projects_status');

        if ($this->bridge->contentTypeCreateOrUpdateField(
            'projects',
            'projects_status',
            [
                'name' => 'projects_status',
                'searchable' => true,
                'translatable' => false,
                'default' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Statut',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 5,
                    'group' => 'group_options',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['projects_status'],
                    'cardinality' => 1,
                ],
            ]
        )) {
            $this->console->writeln('<info>Le champs <comment>color</comment> du contenu <class>news_categories</class> a bien été mis à jour.</info>');
        } else {
            $this->console->writeln('<error>Le champs <comment>color</comment> du contenu <class>news_categories</class> n\'a pas été mis à jour.</error>');
        }

        $bridge = new BridgeContent();

        $contentMap = [
            'projects_status' => [
                [
                    'title' => 'En cours',
                    'color' => '#E7AE5A',
                ],
                [
                    'title' => 'Terminé',
                    'color' => '#51CE71'
                ],
            ],
        ];

        foreach ($contentMap as $contentType => $contents) {
            foreach ($contents as $content) {
                $bridge->contentInsert(
                    $contentType,
                    array_merge([
                        'type' => 'node',
                        'bundle' => $contentType,
                    ], $content)
                );
            }
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
