<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class CreateInsideNewslettersSentTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('inside_newsletters_sent')) {
            Schema::create('inside_newsletters_sent', function (Blueprint $table) {
                $table->uuid('uuid')->collate('utf8');
            });
        }

        $types = NotificationType::whereIn('model', ['Inside\Content\Models\Contents\Newsletters', 'Inside\Content\Models\Contents\NewslettersHr'])->where('action', 'createOrUpdate')->get();

        foreach ($types as $type) {
            $type->action = 'newsletter';
            $type->save();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_newsletters_sent');
    }
}
