<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'name' => 'projects',
        'title' => [
            'fr' => 'Projets',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'background',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Image de fond',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Couleur',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'logo',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Logo',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'key_numbers_background',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Couleur de fond des nombres clés',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'key_numbers_separator',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Couleur de séparation des nombres clés',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'key_number_1',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Nombre clé 1'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'key_number_2',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Nombre clé 2'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 6,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'key_number_3',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Nombre clé 3'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 7,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'video',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Vidéo',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 8,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'client_advisers',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Conseiller client'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 9,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'experts',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Experts'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'support_functions',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 11,
            'title' => [
                'fr' => 'Fonctions Support'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 11,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'comments',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Commentaires',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::COMMENT_FIELD,
            'settings' => [
                'comment_type' => 'comments',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_title_1',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'Nom du ficher 1',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 12,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_1',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 13,
            'title' => [
                'fr' => 'Fichier 1',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 13,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_title_2',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 14,
            'title' => [
                'fr' => 'Nom du ficher 2',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 14,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_2',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 14,
            'title' => [
                'fr' => 'Fichier 2',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 14,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_title_3',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 16,
            'title' => [
                'fr' => 'Nom du ficher 3',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 16,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_3',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 17,
            'title' => [
                'fr' => 'Fichier 3',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 17,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_title_4',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 18,
            'title' => [
                'fr' => 'Nom du ficher 4',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 18,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_4',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 19,
            'title' => [
                'fr' => 'Fichier 4',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 19,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_title_5',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 20,
            'title' => [
                'fr' => 'Nom du ficher 5',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 20,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'file_5',
            'searchable' => true,
            'translatable' => false,
            'default' => false,
            'search_result_field' => true,
            'required' => false,
            'weight' => 21,
            'title' => [
                'fr' => 'Fichier 5',
            ],
            'widget' => [
                'type' => BridgeContentType::FILE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                ],
                'weight' => 21,
            ],
            'type' => BridgeContentType::FILE_FIELD,
            'settings' => [
                'display_field' => false,
                'display_default' => false,
                'uri_scheme' => 'public',
                'target_type' => 'file',
                'cardinality' => 1,
            ],
        ],
    ]
];
