<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'name' => 'direct_popin',
        'title' => [
            'fr' => 'Pop-in Le Direct',
        ],
    ],
    'fields' => [
        [
            'name' => 'activated',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Activation de la popin'
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => $weight++,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'date',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Date',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'show_description',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Description de l\'émission'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'popin_link',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Lien émission',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'last_shows',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Précédentes émissions'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['last_shows'],
                'cardinality' => 1,
            ],
        ],
    ]
];
