<?php

return [
'types'  => [
        'direct_pages' => [
            'category' => null,
            'comments' => false,
            'likes'    => false,
        ],
        'news' => [
            'category' => 'news_categories',
            'comments' => true,
            'likes'    => true,
        ],
        'documents' => [
            'category' => 'folders',
            'comments' => false,
            'likes'    => true,
        ],
        'rh_documents' => [
            'category' => 'rh_folders',
            'comments' => false,
            'likes'    => true,
        ],
        'articles_bca_assistance' => [
            'category' => 'bca_assistance_categories',
            'comments' => true,
            'likes'    => true,
        ],
        'events' => [
            'category' => 'events_categories',
            'comments' => true,
            'likes'    => true,
        ],
        'olympics' => [
            'category' => null,
            'comments' => false,
            'likes' => false
        ],
        'olympics_semifinal' => [
            'category' => null,
            'comments' => false,
            'likes' => false
        ],
        'olympics_final' => [
            'category' => null,
            'comments' => false,
            'likes' => false
        ]
    ],
    'export' => [
        'contents'       => [
            'headers'    => [
                'uuid'         => 'UUID',
                'content_type' => 'Content type',
                'title'        => 'Title',
                'edit'         => 'Edit link',
            ],
            'presenters' => [
                'edit' => function ($value, $model) {
                    return env('APP_URL') . '/edit/' . class_to_type($model) . '/' . $model->uuid;
                },
            ],
        ],
        'users'          => [
            'headers' => [
                'email'    => 'Mail address',
                'full_name' => 'Full name',
            ],
        ],
        'authentication' => [
            'headers' => [],
        ],
    ],
];
