<?php

use Adldap\Models\Entry;
use Drupal\Core\File\FileSystemInterface;
use Inside\Back\Facades\Inside;
use Inside\Content\Models\Contents\Users;

return [
    'sync_attributes' => [
        'mail'          => 'mail',
        'name'          => 'mail',
        'firstname'     => 'givenname',
        'lastname'      => 'sn',
        'fullname'      => 'cn',
        'function'      => 'title',
        'mobile_phone'  => 'mobile',
        'phone'         => 'telephonenumber',
        #'image'         => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
        #    $insideUser = Users::query()->where('name', $user->getFirstAttribute('mail'))->first();
        #
        #    /**
        #     * If the user already has a picture set, return false.
        #     * The image attribute will then be removed in the post_sync callback
        #     */
        #    if ($insideUser && !empty($insideUser->getAttribute('image'))) {
        #        return false;
        #    }
        #
        #    $initials = $user->getFirstAttribute('initials');
        #
        #    if (empty($initials)) {
        #        return null;
        #    }
        #
        #    $path = env('IBCA_PICTURES_PATH', '/mnt/Photos_whoswho') . '/' . $initials . '.jpg';
        #
        #    if (!file_exists($path)) {
        #        return null;
        #    }
        #
        #    $file = file_get_contents($path);
        #
        #    if (empty($file)) {
        #        return null;
        #    }
        #
        #    $directory = 'public://users/';
        #    file_prepare_directory($directory, 1);
        #    $file = file_save_data($file, $directory . $initials . '.jpg', 1);
        #
        #    return $file->getFileUri();
        #},
        'services'      => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
            if (!$user->hasAttribute('department')) {
                return null;
            }

            $services = [];

            $userServices = $user->getAttribute('department');

            foreach ($userServices as $serviceName) {
                if (empty($serviceName)) {
                    continue;
                }

                $uuid = false;
                $service = \Inside\Content\Models\Contents\Services::where('title', $serviceName)
                    ->first();

                if ($service) {
                    $uuid = $service->uuid;
                } else {
                    $uuidBridge = $bridge->contentInsert('services', [
                        'type' => 'node',
                        'bundle' => 'services',
                        'title' => $serviceName,
                        'uid' => 1,
                    ]);

                    $service = \Inside\Content\Models\Contents\Services::find($uuidBridge);

                    if ($service) {
                        $uuid = $service->uuid;
                    }
                }

                if ($uuid) {
                    $services[] = $uuid;
                }
            }

            if (!empty($services)) {
                return $services;
            }

            return null;
        },
        'sites'      => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
            if (!$user->hasAttribute('physicaldeliveryofficename')) {
                return null;
            }

            $sites = [];

            $userSites = $user->getAttribute('physicaldeliveryofficename');

            foreach ($userSites as $siteName) {
                if (empty($siteName)) {
                    continue;
                }

                $uuid = false;
                $site = \Inside\Content\Models\Contents\Sites::where('title', $siteName)
                    ->first();

                if ($site) {
                    $uuid = $site->uuid;
                } else {
                    $uuidBridge = $bridge->contentInsert('sites', [
                        'type' => 'node',
                        'bundle' => 'sites',
                        'title' => $siteName,
                        'uid' => 1,
                    ]);

                    $site = \Inside\Content\Models\Contents\Sites::find($uuidBridge);

                    if ($site) {
                        $uuid = $site->uuid;
                    }
                }

                if ($uuid) {
                    $sites[] = $uuid;
                }
            }

            if (!empty($sites)) {
                return $sites;
            }

            return null;
        },
        'address' => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
            $formatted = '';

            $address = $user->getFirstAttribute('streetaddress');
            $postalCode = $user->getFirstAttribute('postalcode');
            $city = $user->getFirstAttribute('l');
            $country = $user->getFirstAttribute('co');

            if (!empty(trim($address))) {
                $formatted .= trim($address) . "\n";
            }

            if (!empty(trim($postalCode))) {
                $formatted .= $postalCode . ' ';

                if (!empty($city)) {
                    $formatted .= $city . ' ';
                }
            }

            if (!empty(trim($country))) {
                $formatted .= $country;
            }

            return $formatted;
        },
        'users' => function (Entry $user, \Inside\Host\Bridge\BridgeContent $bridge) {
            $managerLdapAttributes = $user->getFirstAttribute('manager');

            if (empty($managerLdapAttributes)) {
                return null;
            }

            $managerLdapAttributes = explode(',', $managerLdapAttributes);

            $managerNames = [];
            foreach ($managerLdapAttributes as $managerLdapAttribute) {
                $managerLdapAttribute = explode('=', $managerLdapAttribute);

                if ($managerLdapAttribute[0] !== 'CN') {
                    continue;
                }

                $managerNames[] = $managerLdapAttribute[1];
            }

            if (empty($managerNames)) {
                return null;
            }

            $managers = [];

            foreach ($managerNames as $managerName) {
                $manager = Users::where('fullname', $managerName)
                    ->first();

                if ($manager) {
                    $managers[] = $manager->uuid;
                }
            }

            if (empty($managers)) {
                return null;
            }

            return $managers;
        }
    ],
    'cleandata' => function (&$datas) {
        if ($datas['image'] === false) {
            unset($datas['image']);
        }
    },
];
