import { http } from '@inside-library/helpers/Http'

export default {
  ennovLinks: {
    add: async ({ data }) => {
      try {
        const { data: procedureData } = await http.get('content/ennov_links', {
          fields: [
            'uuid',
            'title',
            { procedures_folders: ['uuid', 'title', 'slug'] }
          ],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'EnnovLinksPage',
          params: { slug: procedureData[0].procedures_folders.slug[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: procedureData } = await http.get('content/ennov_links', {
          fields: [
            'uuid',
            'title',
            { procedures_folders: ['uuid', 'title', 'slug'] }
          ],
          filters: {
            'uuid:eq': uuid
          }
        })

        return {
          name: 'EnnovLinksPage',
          params: { slug: procedureData[0].procedures_folders.slug[0] }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  crossroadsPage: {
    add: async ({ data }) => {
      const { data: pages } = await http.get('content/crossroads_page', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'uuid:eq': data.uuid }
      })

      const page = pages[0]

      return {
        name: 'CrossroadPage',
        params: {
          slug: page.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pages } = await http.get('content/crossroads_page', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'uuid:eq': uuid }
      })

      const page = pages[0]

      return {
        name: 'CrossroadPage',
        params: {
          slug: page.slug[0]
        }
      }
    }
  },
  infoContent: {
    add: ({ data }) => ({
      name: 'InfoContentPage',
      params: { slug: data.slug[0] }
    })
  },
  infoContentCategories: {
    add: async ({ data }) => {
      const { data: pages } = await http.get(
        'content/info_content_categories',
        {
          fields: [
            'uuid',
            'title',
            { crossroads_page: ['uuid', 'title', 'slug'] }
          ],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const page = pages[0]

      return {
        name: 'CrossroadPage',
        params: {
          slug: page.crossroads_page?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pages } = await http.get(
        'content/info_content_categories',
        {
          fields: [
            'uuid',
            'title',
            { crossroads_page: ['uuid', 'title', 'slug'] }
          ],
          filters: { 'uuid:eq': uuid }
        }
      )

      const page = pages[0]

      return {
        name: 'CrossroadPage',
        params: {
          slug: page.crossroads_page?.slug[0]
        }
      }
    }
  },
  linksPage: {
    add: ({ data }) => ({
      name: 'LinksPage',
      params: { slug: data.slug[0] }
    })
  },
  needsPage: {
    add: async ({ data }) => {
      const { data: contents } = await http.get('content/needs_page', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            services_space: ['uuid', 'title', 'slug']
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug: content.services_space?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: contents } = await http.get('content/needs_page', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            services_space: ['uuid', 'title', 'slug']
          }
        ],
        filters: { 'uuid:eq': uuid }
      })

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug: content.services_space?.slug[0]
        }
      }
    }
  },
  menuSelf: {
    add: () => ({
      name: 'SelfCateringMenu'
    }),
    delete: () => ({
      name: 'SelfCateringMenu'
    })
  },
  proceduresFolders: {
    add: () => ({ name: 'ProceduresListingPage' }),
    delete: () => ({ name: 'ProceduresListingPage' })
  },
  services: {
    add: () => ({ name: 'ServicesDirectoryPage' }),
    delete: () => ({ name: 'ServicesDirectoryPage' })
  },
  servicesSpace: {
    add: ({ data }) => {
      return {
        name: 'SpacePage',
        params: {
          slug: data.slug[0]
        }
      }
    },
    delete: () => ({ name: 'SpacesListingPage' })
  },
  servicesPageGroup: {
    add: async ({ data }) => {
      const { data: contents } = await http.get('content/services_page_group', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            services_space: ['uuid', 'title', 'slug']
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug: content.services_space?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: contents } = await http.get('content/services_page_group', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            services_space: ['uuid', 'title', 'slug']
          }
        ],
        filters: { 'uuid:eq': uuid }
      })

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug: content.services_space?.slug[0]
        }
      }
    }
  },
  servicesPresentation: {
    add: async ({ data }) => {
      const { data: contents } = await http.get(
        'content/services_presentation',
        {
          fields: [
            'uuid',
            'title',
            'slug',
            {
              services_space: ['uuid', 'title', 'slug']
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug: content.services_space?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: contents } = await http.get(
        'content/services_presentation',
        {
          fields: [
            'uuid',
            'title',
            'slug',
            {
              services_space: ['uuid', 'title', 'slug']
            }
          ],
          filters: { 'uuid:eq': uuid }
        }
      )

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug: content.services_space?.slug[0]
        }
      }
    }
  },
  servicesTabs: {
    add: async ({ data }) => {
      const { data: contents } = await http.get('content/services_tabs', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            services_space: ['uuid', 'title', 'slug']
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug: content.services_space?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: contents } = await http.get('content/services_tabs', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            services_space: ['uuid', 'title', 'slug']
          }
        ],
        filters: { 'uuid:eq': uuid }
      })

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug: content.services_space?.slug[0]
        }
      }
    }
  },
  servicesContent: {
    add: async ({ data }) => {
      const { data: contents } = await http.get('content/services_content', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            services_space: ['uuid', 'title', 'slug']
          },
          {
            services_page_group: [
              'uuid',
              'title',
              'slug',
              {
                services_space: ['uuid', 'title', 'slug']
              }
            ]
          },
          {
            services_tabs: [
              'uuid',
              'title',
              'slug',
              {
                services_space: ['uuid', 'title', 'slug']
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug:
            content.services_page_group?.services_space?.slug[0] ||
            content.services_tabs?.services_spaces?.slug[0] ||
            content.services_space?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: contents } = await http.get('content/services_content', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            services_space: ['uuid', 'title', 'slug']
          },
          {
            services_page_group: [
              'uuid',
              'title',
              'slug',
              {
                services_space: ['uuid', 'title', 'slug']
              }
            ]
          },
          {
            services_tabs: [
              'uuid',
              'title',
              'slug',
              {
                services_space: ['uuid', 'title', 'slug']
              }
            ]
          }
        ],
        filters: { 'uuid:eq': uuid }
      })

      const content = contents[0]

      return {
        name: 'SpacePage',
        params: {
          slug:
            content.services_page_group?.services_space?.slug[0] ||
            content.services_tabs?.services_spaces?.slug[0] ||
            content.services_space?.slug[0]
        }
      }
    }
  },
  toKnow: {
    add: async ({ data }) => {
      const { data: toKnow } = await http.get('content/to_know', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            to_know_categories: ['uuid', 'title', 'slug']
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      const toKnowSlug = toKnow[0].to_know_categories?.data[0]?.slug[0]

      return {
        name: 'ToKnowPage',
        params: {
          slug: toKnowSlug
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: toKnow } = await http.get('content/to_know', {
        fields: [
          'uuid',
          'title',
          'slug',
          {
            to_know_categories: ['uuid', 'title', 'slug']
          }
        ],
        filters: { 'uuid:eq': uuid }
      })

      const toKnowSlug = toKnow[0].to_know_categories?.data[0]?.slug[0]

      return {
        name: 'ToKnowPage',
        params: {
          slug: toKnowSlug
        }
      }
    },
    globalSearch: ({ data, vm }) => ({
      action: () => {
        vm.triggerModal(
          'to-know',
          'fetch',
          {
            item: {
              content_type: data.content_type,
              ...data
            },
            content: data.content_type
          },
          { layout: 'right', transition: 'fadeInLeft' }
        )
      }
    })
  },
  toKnowCategories: {
    add: async ({ data }) => {
      const { data: toKnowCategories } = await http.get(
        'content/to_know_categories',
        {
          fields: ['uuid', 'title', 'slug'],
          filters: { 'uuid:eq': data.uuid }
        }
      )

      const toKnowSlug = toKnowCategories[0].slug[0]

      return {
        name: 'ToKnowPage',
        params: {
          slug: toKnowSlug
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: toKnowCategories } = await http.get(
        'content/to_know_categories',
        {
          fields: ['uuid', 'title', 'slug'],
          filters: { 'uuid:eq': uuid }
        }
      )

      const toKnowSlug = toKnowCategories[0].slug[0]

      return {
        name: 'ToKnowPage',
        params: {
          slug: toKnowSlug
        }
      }
    }
  },
  users: {
    add: () => ({ name: 'StaffDirectoryPage' }),
    delete: () => ({ name: 'StaffDirectoryPage' })
  }
}
