import { http } from '@inside-library/helpers/Http'

export const fetchLinksPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/links_page', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'admin',
        {
          tools_categories: {
            fields: [
              'uuid',
              'title',
              'admin',
              'content_type',
              {
                tools: {
                  fields: [
                    'uuid',
                    'title',
                    'has_section',
                    'class',
                    'image',
                    'tools_link',
                    'content_type',
                    'admin'
                  ],
                  filters: { 'status:eq': 1, sort: 'weight:asc', reverse: true }
                }
              }
            ],
            filters: { 'status:eq': 1, reverse: true, sort: 'weight:asc' }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
