export default {
  methods: {
    $_handleClick(item) {
      if (item.services_content_link) {
        this.$_openLink(item.services_content_link)
      } else if (item.is_modale) {
        this.$_openModal(item.uuid)
      } else {
        this.$_redirect(item.slug[0])
      }
    },
    $_openLink(link) {
      window.open(link, '_blank')
    },
    $_redirect(url) {
      this.$router.push(`/${url}`)
    },
    $_openModal(uuid) {
      this.triggerModal(
        'service-page',
        'fetch',
        {
          item: {
            uuid: uuid,
            content_type: 'services_content'
          }
        },
        { layout: 'right', size: 'm', transition: 'fadeInLeft' }
      )
    }
  }
}
