import { http } from '@inside-library/helpers/Http'

export const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/services_space', {
      filters: {
        slug: $route.params.slug,
        'status:eq': 1
      },
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'video',
        'embed_video',
        'video_link',
        'subspaces_title',
        'subspaces_presentation',
        'text_bloc_image',
        'free_text_bloc',
        'tabs_title',
        {
          structure: {
            fields: ['title', 'uuid'],
            filters: { 'status:eq': 1 }
          }
        },
        {
          news_categories: {
            fields: [
              'title',
              'uuid',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'image',
                    'chapo',
                    'content_type',
                    'published_at',
                    { news_categories: ['uuid', 'title'] }
                  ],
                  filters: {
                    reverse: true,
                    limit: 5,
                    'status:eq': 1,
                    'published_at:lte': 'now()',
                    sort: 'published_at:desc'
                  }
                }
              }
            ],
            filters: { 'status:eq': 1 }
          }
        },
        {
          key_contacts: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'phone',
              'users_functions',
              {
                structure: {
                  fields: ['title', 'color', 'uuid'],
                  filters: { 'status:eq': 1 }
                }
              },
              {
                services: {
                  fields: ['title'],
                  filters: { 'status:eq': 1 }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          events_categories: {
            fields: [
              'uuid',
              'title',
              'color',
              {
                events: {
                  fields: [
                    'title',
                    'uuid',
                    'slug',
                    'date',
                    'end_date',
                    'place',
                    'admin',
                    'content_type',
                    {
                      structure: {
                        fields: ['title', 'color'],
                        filters: { 'status:eq': 1 }
                      }
                    }
                  ],
                  filters: {
                    'date:gte': 'now()',
                    sort: 'date:asc',
                    'status:eq': 1,
                    reverse: true,
                    limit: 4
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          info_content: {
            fields: [
              'title',
              'uuid',
              'slug',
              'is_modale',
              'content_type',
              'link',
              {
                info_content_categories: {
                  fields: [
                    'title',
                    'uuid',
                    'link',
                    {
                      crossroads_page: {
                        fields: ['title', 'uuid', 'slug'],
                        filters: {
                          limit: 1,
                          'status:eq': 1
                        }
                      }
                    }
                  ],
                  filters: {
                    'status:eq': 1,
                    limit: 1,
                    sort: 'published_at:desc'
                  }
                }
              }
            ]
          }
        },
        {
          tools: {
            fields: ['title', 'uuid', 'tools_link', 'image', 'content_type'],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          services_presentation: {
            fields: [
              'uuid',
              'title',
              'admin',
              'content_type',
              'cta_label',
              'display_button',
              'is_modale',
              'link',
              'slug',
              'summary',
              'published_at'
            ],
            filters: {
              'status:eq': 1,
              reverse: true
            }
          }
        },
        {
          spaces_footer_blocs: {
            fields: [
              'footer_link_title',
              'footer_link',
              'uuid',
              'image',
              'title',
              'admin',
              'content_type'
            ],
            filters: { 'status:eq': 1 }
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchServiceSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/services_content', {
      filters: {
        slug: $route.params.slug,
        'status:eq': 1
      },
      fields: [
        'uuid',
        'title',
        'pid',
        'content',
        'admin',
        'content_type',
        'image',
        {
          services_page_group: [
            'uuid',
            'title',
            'slug',
            { services_space: ['uuid', 'title', 'slug', 'status'] }
          ]
        },
        { services_space: ['uuid', 'title', 'slug', 'status'] }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchTabs = async ({ $route }) => {
  try {
    const serviceTabs = await http.get('content/services_tabs', {
      filters: {
        sort: 'order:asc',
        services_space: {
          'slug:eq': $route.params.slug
        },
        'status:eq': 1
      },
      fields: ['title', 'uuid', 'admin', 'content_type']
    })

    const serviceContents = await http.get('content/services_content', {
      filters: {
        limit: 5,
        sort: 'order:asc',
        services_tabs: {
          'uuid:in': serviceTabs.data.map(tab => tab.uuid)
        },
        'status:eq': 1
      },
      fields: [
        'title',
        'uuid',
        'chapo',
        'slug',
        'services_content_link',
        'services_space',
        'is_modale',
        'display_as_cta',
        'image',
        'content_type',
        'admin',
        { services_tabs: { fields: ['uuid'] } }
      ]
    })

    return {
      tabs: serviceTabs.data,
      contents: serviceContents.data
    }
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchNeedsPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/needs_page', {
      filters: {
        sort: 'order:asc',
        services_space: {
          slug: $route.params.slug
        },
        'status:eq': 1
      },
      fields: ['title', 'uuid', 'content_type', 'is_modale', 'link', 'slug']
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchCta = async ({ $route }) => {
  try {
    const serviceContents = await http.get('content/services_content', {
      filters: {
        sort: 'order:asc',
        'status:eq': 1,
        services_space: { 'slug:eq': $route.params.slug },
        display_as_cta: true
      },
      fields: [
        'title',
        'uuid',
        'services_content_link',
        'services_space',
        'is_modale',
        'display_as_cta',
        'image',
        'admin',
        'content_type',
        'slug',
        { services_page_group: { fields: ['uuid'] } },
        { services_tabs: { fields: ['uuid'] } }
      ]
    })

    return serviceContents.data
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchPagesInGroups = async ({ $route }) => {
  try {
    const serviceGroups = await http.get('content/services_page_group', {
      filters: {
        sort: 'order:asc',
        services_space: {
          slug: $route.params.slug
        },
        'status:eq': 1
      },
      fields: ['title', 'uuid', 'image', 'admin', 'content_type']
    })

    const serviceContents = await http.get('content/services_content', {
      filters: {
        sort: 'order:asc',
        services_page_group: {
          'uuid:in': serviceGroups.data.map(group => group.uuid)
        },
        'status:eq': 1
      },
      fields: [
        'title',
        'uuid',
        'slug',
        'services_content_link',
        'services_space',
        'is_modale',
        'display_as_cta',
        'admin',
        'content_type',
        { services_page_group: { fields: ['uuid'] } }
      ]
    })

    return {
      groups: serviceGroups.data,
      contents: serviceContents.data
    }
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchServicePresentation = async ({ $route }) => {
  try {
    const { data } = await http.get('content/services_presentation', {
      filters: {
        slug: $route.params.slug,
        'status:eq': 1
      },
      fields: [
        'uuid',
        'title',
        'pid',
        'content',
        'admin',
        'content_type',
        'image',
        { services_space: ['uuid', 'title', 'slug'] }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
