import { http } from '@inside-library/helpers/Http'

export const fetchProcedureFolder = async ({ $route }) => {
  try {
    const { data } = await http.get('content/procedures_folders', {
      fields: ['uuid', 'admin', 'slug', 'content_type', 'title'],
      filters: { 'status:eq': 1, 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
