import LinksPage from '../pages/LinksPage'
import { fetchLinksPage } from '../fetch'

import CategoryNewsListingPage from '../pages/news/CategoryNewsListingPage'
import { fetchNewsCategory } from '../components/news/fetch'


import ProceduresPage from '../pages/procedures/ProceduresPage'
import { fetchProcedureFolder } from '../components/procedures/fetch'

import ToKnowPage from '../pages/to-know/ToKnowPage'
import EnnovLinksPage from '../pages/procedures/EnnovLinksPage'
import { fetchToKnowCategory } from '../components/to-know/fetch'

import CrossroadPage from '../pages/crossroad/CrossroadPage'
import InfoContentPage from '../pages/crossroad/InfoContentPage'
import {
  fetchCrossroadPage,
  fetchInfoContent
} from '../components/crossroad-page/fetch'

import SpacePage from '../pages/services-spaces/SpacePage'
import ServiceSpacePage from '../pages/services-spaces/ServiceSpacePage'
import ServicePresentationPage from '../pages/services-spaces/ServicePresentationPage'
import {
  fetchSpace,
  fetchServiceSpace,
  fetchServicePresentation
} from '../components/services-spaces/fetch'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'StaffDirectoryPage',
    path: '/annuaire-des-collaborateurs',
    component: () => import('../pages/directories/StaffDirectoryPage')
  },
  {
    name: 'ServicesDirectoryPage',
    path: '/annuaire-des-services',
    component: () => import('../pages/directories/ServicesDirectoryPage')
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    component: () => import('../pages/ToolsPage'),
    path: '/outils'
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsPage')
  },
  {
    name: 'CategoryNewsListingPage',
    component: withFetch(CategoryNewsListingPage, { size: 'xxl', watch: true })(
      fetchNewsCategory
    ),
    path: '/categorie-actualite/:uuid'
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false },
    component: () => import('../pages/events/EventsCalendarPage')
  },
  {
    name: 'EventPage',
    meta: { disabled: false },
    component: () => import('../pages/events/EventPage')
  },
  {
    name: 'LinksPage',
    path: '/liens/:slug',
    component: withFetch(LinksPage, { size: 'xxl', watch: true })(
      fetchLinksPage
    )
  },
  {
    name: 'JobOfferPage',
    path: '/offres-emploi',
    component: () => import('../pages/JobOfferPage')
  },
  {
    name: 'SelfCateringMenu',
    path: '/le-menu-du-self',
    component: () => import('../pages/menu/SelfCateringMenu')
  },
  {
    name: 'ProceduresListingPage',
    path: '/procedures-fei',
    component: () => import('../pages/procedures/ProceduresListingPage')
  },
  {
    name: 'ProceduresPage',
    path: '/procedures/:slug',
    component: withFetch(ProceduresPage, { size: 'xxl', watch: true })(
      fetchProcedureFolder
    )
  },
  {
    name: 'ToKnowPage',
    path: '/a-savoir/:slug',
    component: withFetch(ToKnowPage, { size: 'xxl', watch: true })(
      fetchToKnowCategory
    )
  },
  {
    name: 'EnnovLinksPage',
    path: '/liens-ennov/:slug',
    component: withFetch(EnnovLinksPage, { size: 'xxl', watch: true })(
      fetchProcedureFolder
    )
  },
  {
    name: 'PressPage',
    path: '/ghpsj-dans-la-presse',
    component: () => import('../pages/press/PressPage')
  },
  {
    name: 'UnionsPage',
    path: '/newsletter-ensemble',
    component: () => import('../pages/unions/UnionsPage')
  },
  {
    name: 'CrossroadPage',
    path: '/page-carrefour/:slug',
    component: withFetch(CrossroadPage, { size: 'xxl' })(fetchCrossroadPage)
  },
  {
    name: 'InfoContentPage',
    path: '/contenu-info/:slug',
    component: withFetch(InfoContentPage, { size: 'xxl' })(fetchInfoContent)
  },
  {
    name: 'SpacesListingPage',
    path: '/espaces-metiers',
    component: () => import('../pages/services-spaces/SpacesListingPage')
  },
  {
    name: 'SpacePage',
    path: '/espaces-metiers/:slug',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace)
  },
  {
    name: 'ServiceSpacePage',
    path: '/pages-metiers/:slug',
    component: withFetch(ServiceSpacePage, { size: 'xxl', watch: true })(
      fetchServiceSpace
    )
  },
  {
    name: 'ServicePresentationPage',
    path: '/pages-presentation/:slug',
    component: withFetch(ServicePresentationPage, { size: 'xxl', watch: true })(
      fetchServicePresentation
    )
  },
  {
    name: 'GedPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
