export default {
  beforeMount() {
    this.$_deleteItemsById('bookmarks')
  },
  methods: {
    scaffoldCategories(fields) {
      return [
        ...this.getCheckedData(fields, ['news_categories', 'data'], []).map(
          ({ slug, title, color }) => ({
            class: 'category item',
            tag: slug ? 'router-link' : 'span',
            data: { to: this.getCheckedData(slug, 0), style: { color } },
            value: title
          })
        ),
        ...this.$_insertIf(this.isAlive(fields, ['structure']), {
          class: 'category structure item',
          tag: 'router-link',
          data: {
            to: this.getCheckedData(fields, ['structure', 'slug', 0]),
            style: {
              color: this.getCheckedData(fields, ['structure', 'color'])
            }
          },
          value: this.getCheckedData(fields, ['structure', 'title'])
        })
      ]
    }
  }
}
