import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-commons': {
    banner: {
      backgroundColor: '#007294'
    }
  },
  'inside-administration': {
    disabledAdvancedSettingsFields: [
      'welcome_title_homepage',
      'welcome_subtitle_homepage',
      'heromodule_textcolor']
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true
    },
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    },
    adminExportDefaultFields: [
      'firstname',
      'lastname',
      'structure.title',
      'services.title',
      'users_functions.title',
      'specialties.title',
      'email',
      'mobile'
    ],
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        displayAttributes: ({ item }) => ({
          bookmarkEnabled: false,
          image: getContentImage(item.image, 'avatar')
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'lastname',
            'firstname',
            'image',
            'phone',
            'email',
            { services: ['title'] },
            { users_functions: ['title'] },
            { structure: ['color', 'title'] }
          ],
          filters: {
            'is_maintenance:eq': 0,
            'status:eq': 1,
            'generic_account:eq': 0
          }
        },
        requestFields: [
          'uuid',
          'lastname',
          'firstname',
          'image',
          'phone',
          'email',
          { services: ['title'] },
          { users_functions: ['title'] },
          { structure: ['color', 'title'] }
        ]
      }
    }
  },
  'inside-events': {
    rootRoute: { fr: 'agenda' },
    templates: {
      fullContent: {
        mainComponent: () => import('@inside-events/components/lib/Full'),
        mainFields: () => [
          'content',
          'image',
          'disable_comments',
          'date',
          'end_date',
          'place',
          'display_hours',
          { structure: ['uuid', 'title', 'color'] }
        ]
      }
    }
  },
  'inside-layouts': {
    displayInsideLogo: false
  },
  'inside-news': {
    showBookmarks: false,
    templates: {
      fullContent: {
        mainComponent: () => import('@inside-news/components/lib/Full'),
        mainFields: () => [
          'content',
          'image',
          'chapo',
          { structure: ['uuid', 'title', 'color'] },
          {
            news_categories: {
              fields: ['uuid', 'title', 'content_type', 'color'],
              filters: { 'status:eq': 1 }
            }
          }
        ]
      }
    }
  },
  'inside-tools': {
    rootRoute: {
      fr: 'liens-utiles'
    }
  },
  'inside-ged': {
    rootRoute: { fr: 'bibliotheque-de-ressources' }
  },
  globals: {
    icons: {
      bookmark: 'rate',
      bookmarkFill: 'rate-fill'
    }
  }
}
