import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import ServicesModal from '../components/services-listing/ServicesModal'
import ToKnowModal from '../components/to-know/ToKnowModal'
import ServicePageModal from '../components/services-spaces/modals/ServicePageModal'
import CrossroadModal from '../components/crossroad-page/modals/CrossroadModal'
import FlashInfoModal from '../components/modals/FlashInfoModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('services-modal', ServicesModal)
    app.component('to-know-modal', ToKnowModal)
    app.component('service-page-modal', ServicePageModal)
    app.component('crossroad-modal', CrossroadModal)
    app.component('flash-info-modal', FlashInfoModal)
  })
}
