import { http } from '@inside-library/helpers/Http'

export const fetchToKnowCategory = async ({ $route }) => {
  try {
    const { data } = await http.get('content/to_know_categories', {
      fields: ['uuid', 'admin', 'slug', 'content_type', 'title'],
      filters: { 'status:eq': 1, 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
