import { http } from '@inside-library/helpers/Http'

const fetchNewsCategory = async ({ $route }) => {
  try {
    const { data } = await http.get('content/news_categories', {
      fields: ['uuid', 'title', 'published_at', 'content_type'],
      filters: {
        'status:eq': 1,
        limit: 1,
        'uuid:eq': $route.params.uuid
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchNewsCategory }
