import { http } from '@inside-library/helpers/Http'

export const fetchCrossroadPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/crossroads_page', {
      filters: {
        slug: $route.params.slug
      },
      fields: [
        'uuid',
        'title',
        'subtitle',
        'sub_pages_title',
        'admin',
        'content_type',
        {
          'crossroads_page.crossroads_page': {
            fields: [
              'title',
              'uuid',
              'image',
              'slug',
              'admin',
              'content_type',
              'admin'
            ],
            filters: {
              status: 1,
              reverse: true,
              sort: 'weight:asc',
              alias: 'crossroads_page'
            }
          }
        },
        {
          crossroads_page: {
            fields: ['slug', 'title', 'content_type', 'uuid', 'admin'],
            filters: { alias: 'parent' }
          }
        },
        {
          'info_content_categories.crossroads_page': {
            fields: [
              'title',
              'uuid',
              'admin',
              'content_type',
              {
                info_content: {
                  fields: [
                    'title',
                    'uuid',
                    'admin',
                    'link',
                    'is_modale',
                    'slug',
                    'color',
                    'image',
                    'content_type'
                  ],
                  filters: { status: 1, reverse: true, sort: 'order:asc' }
                }
              }
            ],
            filters: {
              status: 1,
              reverse: true,
              sort: 'order:asc',
              alias: 'info_content_categories'
            }
          }
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchInfoContent = async ({ $route }) => {
  try {
    const { data } = await http.get('content/info_content', {
      filters: {
        slug: $route.params.slug,
        'status:eq': 1
      },
      fields: [
        'uuid',
        'title',
        'slug',
        'admin',
        'content_type',
        'content',
        'published_at',
        {
          info_content_categories: [
            'uuid',
            'title',
            { crossroads_page: ['uuid', 'title', 'slug'] }
          ]
        }
      ]
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
