export default {
  // Services
  services: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'email',
      'fax',
      'locations',
      'image',
      'secretariats',
      'directions',
      'care_stations',
      'nurses',
      'hospitalizations',
      'consultations',
      'internals',
      {
        executives: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'users_functions',
          'phone',
          { services: ['title'] }
        ]
      },
      {
        head_service: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'users_functions',
          'phone',
          { services: ['title'] }
        ]
      },
      {
        referral_ide: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'users_functions',
          'phone',
          { services: ['title'] }
        ]
      },
      {
        assistants: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'users_functions',
          'phone',
          { services: ['title'] }
        ]
      },
      'administrative_assistants',
      'doctor_calls',
      'night_executives',
      'medical_advices',
      'programmings',
      {
        specialties: ['title']
      }
    ]
  },
  // Users
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'email',
      'phone',
      'image',
      'users_functions',
      'dect',
      'mobile',
      'fax',
      'languages',
      'referent',
      'locations',
      'upn',
      {
        services: [
          'title',
          'image',
          'uuid',
          'content_type',
          'directions',
          'clickable'
        ]
      },
      {
        structure: ['title', 'color']
      }
    ]
  },
  // To know
  to_know: {
    modalFields: ['uuid', 'title', 'content']
  }
}
