<?php

declare(strict_types=1);

namespace Inside\HPSJ\Providers;

use Inside\Events\InsideBooted;
use Inside\HPSJ\Console\ServiceImporterCommand;
use Inside\HPSJ\Http\Middleware\GenericAccountMiddleware;
use Inside\HPSJ\Listeners\AddChatbotToFrontend;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

final class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        InsideBooted::class => [
            AddChatbotToFrontend::class,
        ],
    ];

    protected array $commands = [
        ServiceImporterCommand::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/security.php', 'security');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        } catch (NotFoundExceptionInterface | ContainerExceptionInterface) {
        }

        $this->app->middleware([
            GenericAccountMiddleware::class,
        ]);
    }
}
