<?php

namespace Inside\HPSJ\Listeners;

use Illuminate\Http\Request;
use Inside\Authentication\Facades\Authentication;
use Inside\Authentication\Models\User;
use Inside\Events\InsideBooted;
use Inside\Facades\Inside;

class AddChatbotToFrontend
{
    public function handle(InsideBooted $event): void
    {
        $request = request();

        if (!$request instanceof Request || false === env('ACTIVATE_CHATBOT', false)) {
            return;
        }

        Inside::js("https://static.smartrecruiters.com/job-widget/1.6.1/script/smart_widget.js");

        $user = Authentication::getUserFromMagicCookie($request);

        if (!$user instanceof User) {
            return;
        }

        $name = $user->information->getAttribute('samaccountname');

        if (!empty($name)) {
            $jsScript = <<<SCRIPT
window.chatBoxParams = {
    userId: '$name',
    userIdType: 'login',
    userFirstName: '',
    userLastName: '',
    originId: '',
};
SCRIPT;
            Inside::script($jsScript);
            Inside::js("https://webchat.wikit.ai/webchat-embed-multibot.js");
            Inside::js(
                'vendor/maecia/hpsj-back/resources/assets/js/chatbot.js'
            );
        }
    }
}
