<?php

namespace Inside\HPSJ\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Inside\Authentication\Exceptions\AuthenticationException;
use Inside\Authentication\Facades\Authentication;
use Inside\Authentication\Models\Token;
use Inside\Permission\Exceptions\AuthorizationException;
use Symfony\Component\HttpFoundation\Response;

class GenericAccountMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);
        $path = 'oauth2/login';
        $authorizedIps = explode(',', env('HPSJ_GENERIC_ACCOUNT_IPS'));
        if ($request->path() === $path && $response->getStatusCode() === 302 && $request->input('code')) {
            $ip = $request->ip();
            $target = $response->getTargetUrl();
            $token = substr($target, strrpos($target, '/') + 1);

            // find user through the token
            /** @var ?Token $accessToken */
            $accessToken = Token::where('token', Authentication::encryptToken($token))->first();
            if (!$accessToken) {
                throw new AuthenticationException('This user is not active');
            }

            $user = $accessToken->user->information;
            if ($user->generic_account && !in_array($ip, $authorizedIps)) {
                throw new AuthorizationException('This action is unauthorized.');
            }
        }
        return $response;
    }
}
