<?php

namespace Inside\HPSJ\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\News;
use Inside\Permission\Models\User;
use Inside\Reaction\Facades\Reactions;
use Laravel\Lumen\Routing\Controller;

class PopinController extends Controller
{
    public function popin(Request $request): array
    {
        $news = News::query()->where('status', 1)->where('flash_info', 1)->orderBy('created_at', 'DESC')->first();

        if (empty($news)) {
            return [
                'popin' => false
            ];
        }

        /** @var User $user */
        $user = Auth::user();
        $reaction = DB::table('inside_reactions')
            ->where('type', 'infoflash')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $news->uuid)
            ->where('created_at', 'LIKE', date('Y-m-d', time()) . ' %')
            ->orderBy('created_at', 'DESC')->get();

        $count = $reaction->count();

        return [
            'popin' => !(bool)$count,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first()
        ];
    }

    public function reaction(Request $request): Reactions
    {
        /** @var User $user */
        $user = Auth::user();

        /** @var string $uuid */
        $uuid = $request->input('uuid');

        $reactions = DB::table('inside_reactions')
            ->where('type', 'infoflash')
            ->where('user_uuid', $user->uuid)
            ->orderBy('created_at', 'DESC')->get();

        $data = News::findOrFail($uuid);
        if ($reactions->count()) {
            foreach ($reactions as $reaction) {
                Reactions::delete('infoflash', $reaction->reactionable_uuid, $reaction->user_uuid, $reaction->langcode);
            }
        }

        /** @var Reactions $create */
        $create = Reactions::create([
            'user_uuid' => $user->uuid,
            'reactionable_uuid' => $uuid,
            'reactionable_type' => News::class,
            'type' => 'infoflash',
            'langcode' => $data->langcode
        ]);

        return $create;
    }
}
