
<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Services;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ReplaceServiceEmailField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            [
                'name' => 'email',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Email secrétariat',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        ];

        foreach ($fields as $field) {
            $field['name'] .= '_copy';
            $bridge->contentTypeCreateOrUpdateField('services', $field['name'], $field, $field['weight']);
        }

        $services = Services::query()->get();

        $bridgeContent = new BridgeContent();
        foreach ($services as $service) {
            $bridgeContent->contentUpdate('services', [
                'uuid' => $service->uuid,
                'email_copy' => $service->email
            ]);
        }

        foreach ($fields as $field) {
            $bridge->contentTypeDeleteField('node', 'services', $field['name']);
            $bridge->contentTypeCreateOrUpdateField('services', $field['name'], $field, $field['weight']);
        }

        $services = Services::query()->get();
        foreach ($services as $service) {
            $bridgeContent->contentUpdate('services', [
                'uuid' => $service->uuid,
                'email' => $service->email_copy
            ]);
        }

        foreach ($fields as $field) {
            $bridge->contentTypeDeleteField('node', 'services', $field['name'] . '_copy');
        }
    }

    public function down(): void
    {
    }
}
