<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddHideServicesField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'services',
            'is_hidden',
            [
                'name' => 'is_hidden',
                'searchable' => true,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 5,
                'title' => [
                    'fr' => 'Masquer dans l’annuaire des services',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 5
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            5
        );
    }

    public function down(): void
    {
    }
}
