<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddBooleanFieldToServicesType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('services', 'clickable', [
            'name' => 'clickable',
            'searchable' => false,
            'translatable' => false,
            'default' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Cette carte est cliquable ?'
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ], 5);
    }

    public function down(): void
    {
    }
}
