<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Permission\Facades\Permission;

class RemoveCustomPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     */
    public function up(): void
    {
        DB::table('inside_permissions_schema')
            ->join(
                'inside_roles_permissions_schema',
                'inside_permissions_schema.id',
                'inside_roles_permissions_schema.permission_schema_id'
            )
            ->where('inside_roles_permissions_schema.is_content_specific', 1)
            ->where('inside_permissions_schema.action', 'read')->delete();

        DB::table('inside_permissions_schema')
            ->join(
                'inside_roles_permissions_schema',
                'inside_permissions_schema.id',
                'inside_roles_permissions_schema.permission_schema_id'
            )
            ->where('inside_roles_permissions_schema.is_content_specific', 0)
            ->where('inside_permissions_schema.authorizable_type', 'like', '%Menus')
            ->where('inside_permissions_schema.action', '<>', 'read')->delete();
        Permission::buildPermissionForAllRoles();
    }

    public function down(): void
    {
    }
}
